package row_data_gateway;
import db_context.DbContext;
import db_context.MyExceptions;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class ItemsFinder {
    private static final ItemsFinder INSTANCE = new ItemsFinder();
    public static ItemsFinder getInstance() {
        return INSTANCE;
    }
    private ItemsFinder() {
    }

    public Item SetItem(ResultSet r) throws SQLException {
        Item c = new Item();
        c.setId(r.getInt("id"));
        c.setName(r.getString("name"));
        c.setWeight(r.getBigDecimal("weight"));
        c.setPrice(r.getBigDecimal("price"));
        c.setUninsured_ratio(r.getInt("uninsured_ratio"));
        c.setPackage_id(r.getInt("package_id"));
        return c;
    }

    public Item findById(int id) throws SQLException, MyExceptions.NotSuchIdException {

        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM items WHERE id = ?")){
            s.setInt(1, id);
            try (ResultSet r = s.executeQuery()) {
                if (r.next()) {
                    Item c = SetItem(r);
                    if (r.next()) {
                        throw new RuntimeException("Move than one row was returned");
                    }
                    return c;
                } else {
                    throw new MyExceptions.NotSuchIdException("Not such item");
                }
            }
        }
    }

    public List<Item> findAll(int offset) throws SQLException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM items ORDER BY id LIMIT 500 OFFSET ?")) {
            s.setInt(1, 500 * offset);
            try (ResultSet r = s.executeQuery()) {
                List<Item> elements = new ArrayList<>();
                while (r.next()) {
                    Item c = SetItem(r);
                    elements.add(c);
                }
                return elements;
            }
        }
    }

    public List<Item> findByPackageId(int package_id) throws SQLException, MyExceptions.NotSuchIdException {
        try (PreparedStatement s = DbContext.getConnection().prepareStatement("SELECT * FROM items WHERE package_id = ?")) {
            s.setInt(1, package_id);

            try (ResultSet r = s.executeQuery()) {
                List<Item> elements = new ArrayList<>();
                while (r.next()) {
                    Item c = SetItem(r);
                    elements.add(c);
                }

                if(elements.size() == 0) throw new MyExceptions.NotSuchIdException("This package is Empty");
                return elements;
            }
        }
    }
}
